/*
 * Decompiled with CFR 0.152.
 */
package xyz.earthcow.premiumVanishAPITester;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.myzelyam.api.vanish.VelocityPlayerHideEvent;
import de.myzelyam.api.vanish.VelocityPlayerShowEvent;
import de.myzelyam.api.vanish.VelocityVanishAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.slf4j.Logger;

@Plugin(id="premiumvanishapitester", name="PremiumVanishAPITester", version="1.0-SNAPSHOT", authors={"EarthCow"}, dependencies={@Dependency(id="premiumvanish", optional=true)})
public class PremiumVanishAPITester {
    @Inject
    private Logger logger;
    @Inject
    private ProxyServer proxy;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        if (!this.proxy.getPluginManager().isLoaded("premiumvanish")) {
            throw new IllegalStateException("PremiumVanish is required to run this plugin!");
        }
    }

    private void handleEvent(Player player, String eventName) {
        if (VelocityVanishAPI.isInvisible((Player)player)) {
            this.proxy.getConsoleCommandSource().sendMessage((Component)Component.text((String)(eventName + ": You are vanished!"), (TextColor)NamedTextColor.GREEN));
            player.sendMessage((Component)Component.text((String)(eventName + ": You are vanished!"), (TextColor)NamedTextColor.GREEN));
        } else {
            this.proxy.getConsoleCommandSource().sendMessage((Component)Component.text((String)(eventName + ": You are NOT vanished!"), (TextColor)NamedTextColor.RED));
            player.sendMessage((Component)Component.text((String)(eventName + ": You are NOT vanished!"), (TextColor)NamedTextColor.RED));
        }
    }

    @Subscribe
    public void onLoginEvent(LoginEvent event) {
        this.handleEvent(event.getPlayer(), "LoginEvent");
    }

    @Subscribe
    public void onPostLoginEvent(PostLoginEvent event) {
        this.handleEvent(event.getPlayer(), "PostLoginEvent");
    }

    @Subscribe
    public void onServerPreConnect(ServerPreConnectEvent event) {
        this.handleEvent(event.getPlayer(), "ServerPreConnectEvent");
    }

    @Subscribe
    public void onServerConnected(ServerConnectedEvent event) {
        this.handleEvent(event.getPlayer(), "ServerConnectedEvent");
    }

    @Subscribe
    public void onServerPostConnect(ServerPostConnectEvent event) {
        this.handleEvent(event.getPlayer(), "ServerPostConnectEvent");
    }

    @Subscribe
    public void onPlayerHide(VelocityPlayerHideEvent event) {
        this.handleEvent(event.getPlayer(), "VelocityPlayerHideEvent");
    }

    @Subscribe
    public void onPlayerShow(VelocityPlayerShowEvent event) {
        this.handleEvent(event.getPlayer(), "VelocityPlayerShowEvent");
    }
}

