package xyz.earthcow.premiumVanishAPITester;

import com.google.inject.Inject;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.myzelyam.api.vanish.VelocityPlayerHideEvent;
import de.myzelyam.api.vanish.VelocityPlayerShowEvent;
import de.myzelyam.api.vanish.VelocityVanishAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.slf4j.Logger;

@Plugin(
    id = "premiumvanishapitester",
    name = "PremiumVanishAPITester",
    version = BuildConstants.VERSION,
    authors = { "EarthCow" },
    dependencies = {
            // Soft-depend to be as close as possible to the real situation
            @Dependency(id = "premiumvanish", optional = true)
    }
)
public class PremiumVanishAPITester {

    @Inject private Logger logger;
    @Inject private ProxyServer proxy;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        if (!proxy.getPluginManager().isLoaded("premiumvanish")) {
            throw new IllegalStateException("PremiumVanish is required to run this plugin!");
        }
    }

    private void handleEvent(Player player, String eventName) {
        if (VelocityVanishAPI.isInvisible(player)) {
            proxy.getConsoleCommandSource().sendMessage(Component.text(eventName + ": You are vanished!", NamedTextColor.GREEN));
            player.sendMessage(Component.text(eventName + ": You are vanished!", NamedTextColor.GREEN));
        } else {
            proxy.getConsoleCommandSource().sendMessage(Component.text(eventName + ": You are NOT vanished!", NamedTextColor.RED));
            player.sendMessage(Component.text(eventName + ": You are NOT vanished!", NamedTextColor.RED));
        }
    }

    @Subscribe
    public void onLoginEvent(LoginEvent event) {
        handleEvent(event.getPlayer(), "LoginEvent");
    }

    @Subscribe
    public void onPostLoginEvent(PostLoginEvent event) {
        handleEvent(event.getPlayer(), "PostLoginEvent");
    }

    @Subscribe
    public void onServerPreConnect(ServerPreConnectEvent event) {
        handleEvent(event.getPlayer(), "ServerPreConnectEvent");
    }

    @Subscribe
    public void onServerConnected(ServerConnectedEvent event) {
        handleEvent(event.getPlayer(), "ServerConnectedEvent");
    }

    @Subscribe
    public void onServerPostConnect(ServerPostConnectEvent event) {
        handleEvent(event.getPlayer(), "ServerPostConnectEvent");
    }

    // PremiumVanishAPI events

    @Subscribe
    public void onPlayerHide(VelocityPlayerHideEvent event) {
        handleEvent(event.getPlayer(), "VelocityPlayerHideEvent");
    }

    @Subscribe
    public void onPlayerShow(VelocityPlayerShowEvent event) {
        handleEvent(event.getPlayer(), "VelocityPlayerShowEvent");
    }
}
